<?php

/**
 * Class that operate on table 'storedetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class StoredetailMySqlDAO implements StoredetailDAO
{

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return StoredetailMySql
     */
    public function load($id)
    {
        $sql = 'SELECT * FROM storedetail WHERE storedetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll()
    {
        $sql = 'SELECT * FROM storedetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn)
    {
        $sql = 'SELECT * FROM storedetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param storedetail primary key
     */
    public function delete($storedetailid)
    {
        $sql = 'DELETE FROM storedetail WHERE storedetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($storedetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param StoredetailMySql storedetail
     */
    public function insert($storedetail)
    {
        $sql = 'INSERT INTO storedetail (productid, storeid, productquantity, userid, storedetaildate) VALUES (?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($storedetail->productid);
        $sqlQuery->setNumber($storedetail->storeid);
        $sqlQuery->setNumber($storedetail->productquantity);
        $sqlQuery->setNumber($storedetail->userid);
        $sqlQuery->set($storedetail->storedetaildate);

        $id = $this->executeInsert($sqlQuery);
        $storedetail->storedetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param StoredetailMySql storedetail
     */
    public function update($storedetail)
    {
        $sql = 'UPDATE storedetail SET productid = ?, storeid = ?, productquantity = ?, userid = ?, storedetaildate = ? WHERE storedetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($storedetail->productid);
        $sqlQuery->setNumber($storedetail->storeid);
        $sqlQuery->setNumber($storedetail->productquantity);
        $sqlQuery->setNumber($storedetail->userid);
        $sqlQuery->set($storedetail->storedetaildate);

        $sqlQuery->setNumber($storedetail->storedetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean()
    {
        $sql = 'DELETE FROM storedetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductid($value)
    {
        $sql = 'SELECT * FROM storedetail WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value)
    {
        $sql = 'SELECT * FROM storedetail WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductquantity($value)
    {
        $sql = 'SELECT * FROM storedetail WHERE productquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value)
    {
        $sql = 'SELECT * FROM storedetail WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoredetaildate($value)
    {
        $sql = 'SELECT * FROM storedetail WHERE storedetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductid($value)
    {
        $sql = 'DELETE FROM storedetail WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value)
    {
        $sql = 'DELETE FROM storedetail WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductquantity($value)
    {
        $sql = 'DELETE FROM storedetail WHERE productquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value)
    {
        $sql = 'DELETE FROM storedetail WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoredetaildate($value)
    {
        $sql = 'DELETE FROM storedetail WHERE storedetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return StoredetailMySql
     */
    protected function readRow($row)
    {
        $storedetail = new Storedetail();

        $storedetail->storedetailid = isset($row['storedetailid']) ? $row['storedetailid'] : '';
        $storedetail->productid = isset($row['productid']) ? $row['productid'] : '';
        $storedetail->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        $storedetail->productquantity = isset($row['productquantity']) ? (float) $row['productquantity'] : '';
        $storedetail->userid = isset($row['userid']) ? $row['userid'] : '';
        $storedetail->storedetaildate = isset($row['storedetaildate']) ? $row['storedetaildate'] : '';

        //required
        $storedetail->productName = isset($row['productName']) ? $row['productName'] : '';
        $storedetail->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $storedetail->productSellUnitPrice = isset($row['productSellUnitPrice']) ? $row['productSellUnitPrice'] : '';
        $storedetail->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';
        $storedetail->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $storedetail->lastbuyprice_withDiscount = isset($row['lastbuyprice_withDiscount']) ? $row['lastbuyprice_withDiscount'] : '';

        $storedetail->productId = isset($row['productId']) ? $row['productId'] : '';
        $storedetail->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';
        $storedetail->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $storedetail->productSellAllPrice = isset($row['productSellAllPrice']) ? $row['productSellAllPrice'] : '';
        $storedetail->productSellHalfPrice = isset($row['productSellHalfPrice']) ? $row['productSellHalfPrice'] : '';
        $storedetail->unittype = isset($row['unittype']) ? $row['unittype'] : '';
        $storedetail->totQty = isset($row['totQty']) ? $row['totQty'] : '';
        $storedetail->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $storedetail->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $storedetail->lastbuyprice_withTax = isset($row['lastbuyprice_withTax']) ? $row['lastbuyprice_withTax'] : '';
        $storedetail->meanbuyprice_withTax = isset($row['meanbuyprice_withTax']) ? $row['meanbuyprice_withTax'] : '';
        $storedetail->logo = isset($row['logo']) ? $row['logo'] : '';
        $storedetail->selldiscount = isset($row['selldiscount']) ? $row['selldiscount'] : '';
        $storedetail->discounttype = isset($row['discounttype']) ? $row['discounttype'] : '';
        $storedetail->isService = isset($row['isService']) ? $row['isService'] : '';

        $storedetail->sizecolorstoredetailid = isset($row['sizecolorstoredetailid']) ? $row['sizecolorstoredetailid'] : '';
        $storedetail->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $storedetail->colorid = isset($row['colorid']) ? $row['colorid'] : '';
        $storedetail->sizeName = isset($row['sizeName']) ? $row['sizeName'] : '';
        $storedetail->colorName = isset($row['colorName']) ? $row['colorName'] : '';
        $storedetail->overAllAveragePrice = isset($row['overAllAveragePrice']) ? $row['overAllAveragePrice'] : '';
        $storedetail->meanbuyprice_withDiscount = isset($row['meanbuyprice_withDiscount']) ? $row['meanbuyprice_withDiscount'] : '';
        $storedetail->isOptic = isset($row['isOptic']) ? $row['isOptic'] : '';
        $storedetail->productCatParent = isset($row['productCatParent']) ? $row['productCatParent'] : '';
        $storedetail->reviewType = isset($row['reviewType']) ? $row['reviewType'] : '';
        $storedetail->productDescription = isset($row['productDescription']) ? $row['productDescription'] : '';
        $storedetail->hasSizeAndColor = isset($row['hasSizeAndColor']) ? $row['hasSizeAndColor'] : '';
        $storedetail->webApiId = isset($row['webApiId']) ? $row['webApiId'] : '';
        $storedetail->procode = isset($row['procode']) ? $row['procode'] : '';
        $storedetail->lastbuyprice_withTax = isset($row['lastbuyprice_withTax']) ? $row['lastbuyprice_withTax'] : '';
        $storedetail->meanbuyprice_withTax = isset($row['meanbuyprice_withTax']) ? $row['meanbuyprice_withTax'] : '';
        $storedetail->limitamount = isset($row['limitamount']) ? $row['limitamount'] : '';
        $storedetail->price4 = isset($row['price4']) ? $row['price4'] : '';
        $storedetail->price5 = isset($row['price5']) ? $row['price5'] : '';
        $storedetail->price6 = isset($row['price6']) ? $row['price6'] : '';
        $storedetail->price7 = isset($row['price7']) ? $row['price7'] : '';
        $storedetail->price8 = isset($row['price8']) ? $row['price8'] : '';
        $storedetail->price9 = isset($row['price9']) ? $row['price9'] : '';
        $storedetail->price10 = isset($row['price10']) ? $row['price10'] : '';
        $storedetail->price11 = isset($row['price11']) ? $row['price11'] : '';
        $storedetail->price12 = isset($row['price12']) ? $row['price12'] : '';
        $storedetail->price13 = isset($row['price13']) ? $row['price13'] : '';

        return $storedetail;
    }

    protected function getList($sqlQuery)
    {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return StoredetailMySql
     */
    protected function getRow($sqlQuery)
    {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery)
    {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery)
    {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery)
    {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery)
    {
        return QueryExecutor::executeInsert($sqlQuery);
    }
}
